/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class Token {
    private static Logger log = Logger.getLogger(Token.class);
    private long idSlotToken = -1L;
    private CK_TOKEN_INFO info;

    public Token(PKCS11 pKCS11, long l) throws ExceptionObjet {
        this.idSlotToken = l;
        this.chargeInfo(pKCS11);
    }

    public void chargeInfo(PKCS11 pKCS11) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                this.info = pKCS11.C_GetTokenInfo(this.idSlotToken);
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations de la carte : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(202, "Une erreur est survenue lors de la r\u00e9cuperation des informations de la carte");
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(202, "La librairie est nulle");
        }
    }

    public String getLibelle() {
        if (this.info != null && this.idSlotToken != -1L) {
            return new String(this.info.label).trim() + " (Slot " + this.idSlotToken + ")";
        }
        return "Carte " + Long.toString(this.idSlotToken);
    }

    public long getIdSlotToken() {
        return this.idSlotToken;
    }

    public String getLibelleInit() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.label).trim();
        }
        log.error((Object)"Les informations de la carte sont nulles, le libell\u00e9 application attribu\u00e9 lors de l'initialisation de la carte est indisponible");
        throw new ExceptionObjet(202, "Le libell\u00e9 application attribu\u00e9 lors de l'initialisation de la carte est indisponible");
    }

    public String getFabricant() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.manufacturerID);
        }
        log.error((Object)"Les informations de la carte sont nulles, l'identifiant du fabricant de la carte est indisponible");
        throw new ExceptionObjet(202, "L'identifiant du fabricant de la carte est indisponible");
    }

    public String getModele() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.model);
        }
        log.error((Object)"Les informations de la carte sont nulles, le modele de la carte est indisponible");
        throw new ExceptionObjet(202, "Le mod\u00e8le de la carte est indisponible");
    }

    public String getNumeroSerie() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.serialNumber);
        }
        log.error((Object)"Les informations de la carte sont nulles, le numero de serie de la carte est indisponible");
        throw new ExceptionObjet(202, "Le num\u00e9ro de s\u00e9rie de la carte est indisponible");
    }

    public long getMaxSessionsSimultanees() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMaxSessionCount;
        }
        log.error((Object)"Les informations de la carte sont nulles, le nombre maximum de sessions pouvant etre ouvertes simultanement par une meme application sur la carte est indisponible");
        throw new ExceptionObjet(202, "Le nombre maximum de sessions pouvant \u00eatre ouvertes simultan\u00e9ment par une m\u00eame application sur la carte est indisponible");
    }

    public long getNombreSessionsApplicationCourante() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulSessionCount;
        }
        log.error((Object)"Les informations de la carte sont nulles, le nombre de sessions que l'application courante a d'ouvertes sur la carte est indisponible");
        throw new ExceptionObjet(202, "Le nombre de sessions que l'application courante a d'ouvertes sur la carte est indisponible");
    }

    public long getMaxSessionsSimultaneesEnEcriture() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMaxRwSessionCount;
        }
        log.error((Object)"Les informations de la carte sont nulles, le nombre maximum de sessions en lecture/ecriture pouvant etre ouvertes simultanement par une meme application sur la carte est indisponible");
        throw new ExceptionObjet(202, "Le nombre maximum de sessions en lecture/\u00e9criture pouvant \u00eatre ouvertes simultan\u00e9ment par une m\u00eame application sur la carte est indisponible");
    }

    public long getNombreSessionsEnEcritureOuvertesParApplicationCourante() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulRwSessionCount;
        }
        log.error((Object)"Les informations de la carte sont nulles, le nombre de sessions en lecture/ecriture que l'application courante a d'ouvertes sur la carte est indisponible");
        throw new ExceptionObjet(202, "Le nombre de sessions en lecture/\u00e9criture que l'application courante a d'ouvertes sur la carte est indisponible");
    }

    public long getLongueurMaxPin() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMaxPinLen;
        }
        log.error((Object)"Les informations de la carte sont nulles, la longueur maximale (en octets) du code porteur de la carte est indisponible");
        throw new ExceptionObjet(202, "La longueur maximale (en octets) du code porteur de la carte est indisponible");
    }

    public long getLongueurMinPin() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulMinPinLen;
        }
        log.error((Object)"Les informations de la carte sont nulles, la longueur minimale (en octets) du code porteur de la carte est indisponible");
        throw new ExceptionObjet(202, "La longueur minimale (en octets) du code porteur de la carte est indisponible");
    }

    public long getCapaciteMemoirePublicTotal() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulTotalPublicMemory;
        }
        log.error((Object)"Les informations de la carte sont nulles, la capacite memoire totale (en octets) pour le stockage d'objets publics sur la carte est indisponible");
        throw new ExceptionObjet(202, "La capacit\u00e9 m\u00e9moire totale (en octets) pour le stockage d'objets publics sur la carte est indisponible");
    }

    public long getEspaceMemoirePublicDisponible() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulFreePublicMemory;
        }
        log.error((Object)"Les informations de la carte sont nulles, l'espace memoire disponible (en octets) pour le stockage d'objets publics sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'espace m\u00e9moire disponible (en octets) pour le stockage d'objets publics sur la carte est indisponible");
    }

    public long getCapaciteMemoirePriveTotal() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulTotalPrivateMemory;
        }
        log.error((Object)"Les informations de la carte sont nulles, la capacite memoire totale (en octets) pour le stockage d'objets prives sur la carte est indisponible");
        throw new ExceptionObjet(202, "La capacit\u00e9 m\u00e9moire totale (en octets) pour le stockage d'objets priv\u00e9s sur la carte est indisponible");
    }

    public long getEspaceMemoirePriveDisponible() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.ulFreePrivateMemory;
        }
        log.error((Object)"Les informations de la carte sont nulles, l'espace memoire disponible (en octets) pour le stockage d'objets prives sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'espace m\u00e9moire disponible (en octets) pour le stockage d'objets priv\u00e9s sur la carte est indisponible");
    }

    public String getVersionMaterielle() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.hardwareVersion.toString();
        }
        log.error((Object)"Les informations de la carte sont nulles, le numero de version materielle de la carte est indisponible");
        throw new ExceptionObjet(202, "Le num\u00e9ro de version mat\u00e9rielle de la carte est indisponible");
    }

    public String getVersionFirmware() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.firmwareVersion.toString();
        }
        log.error((Object)"Les informations de la carte sont nulles, le numero de version firmware de la carte est indisponible");
        throw new ExceptionObjet(202, "Le num\u00e9ro de version firmware de la carte est indisponible");
    }

    public String getDate() throws ExceptionObjet {
        if (this.info != null) {
            return new String(this.info.utcTime);
        }
        log.error((Object)"Les informations de la carte sont nulles, la date de la carte est indisponible");
        throw new ExceptionObjet(202, "La date de la carte est indisponible");
    }

    public boolean isGenerateurAleatoire() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 1L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isProtegeEcriture() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 2L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isAuthentificationRequise() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 4L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isPinInitialise() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 8L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isCleRestaurationRequise() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x20L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isHorloge() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x40L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isAuthentificationProtegee() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x100L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isDual() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x200L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isInitialise() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x400L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isAuMoinsUnEchecPin() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x10000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isBloqueAuProchainEchecPin() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x20000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isPinBloque() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x40000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isPinAChanger() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x80000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isAuMoinsUnEchecPuk() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x100000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isBloqueAuProchainEchecPuk() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x200000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isPukBloque() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x400000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public boolean isPukAChanger() throws ExceptionObjet {
        if (this.info != null) {
            return (this.info.flags & 0x800000L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la carte est indisponible");
        throw new ExceptionObjet(202, "L'information sur la carte est indisponible");
    }

    public String toString() {
        return this.getLibelle();
    }
}

